<?php

namespace App\Models;

use App\Models\Client;
use App\Models\map\Device;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Clientsinfo extends Model
{
    use HasFactory;

    protected $table = 'clientsinfo';

    protected $guarded = ['id'];

    public function client()
    {
        return $this->hasOne(Client::class, 'id', 'client_id');
    }


    public function divisions()
    {
        return $this->belongsTo(Division::class, 'division');
    }

    public function districts()
    {
        return $this->belongsTo(District::class, 'district');
    }

    public function upazilas()
    {
        return $this->belongsTo(Upazila::class, 'upazila');
    }

    public function thanas()
    {
        return $this->belongsTo(Thana::class, 'thana');
    }

    // added for relation error handling
    public function device()
    {
        return $this->hasOne(Device::class, 'id', 'device_id');
    }

    public function connectedComponent()
    {
        return $this->morphTo(null, 'connected_component_type', 'connected_component_id');
    }
}
