<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Classes\ExpireCustomerDeactive;
use App\Jobs\ExpireCustomerDeactiveByListJob;
use Illuminate\Support\Facades\Log;

class ExpireCustomerDeactiveCommand extends Command
{

    protected $signature = 'expire-customer:deactive';

    protected $description = 'Deactive All Expire Customer';


    public function __construct()
    {
        parent::__construct();
    }


    public function handle()
    {



        if (checkSettings('auto_deactive_expire_customer') == 'enable') {
            $days = siteinfo()->deactive_after;


            DB::table('clients')
            ->leftJoin('pops', 'clients.pop_id', '=', 'pops.id')
            ->whereRaw("DATE_ADD(expire_date,INTERVAL payment_dadeline DAY) < DATE_SUB(CURDATE() , interval $days day) ")
            ->select('clients.id', 'clients.expire_date', 'clients.clients_status')
            ->where('pops.bill_generate', 'yes')
            ->where('pops.experity_check', 'No')
            ->where('clients.experity_check', 'Yes')
            ->orderBy('clients.id', 'asc')
            ->chunk(100, function ($clients) {
                dispatch(new ExpireCustomerDeactiveByListJob($clients,1));
            });


        }
    }
}
