@extends('layout.app')
@section('content')

    <div class="card">
        <div class="card-body">

            <div class="col-md-2">
                <a class="" href="{{ route('printToken') }}" target="_blank">
                    <button class="mb-2 btn btn-primary ">
                        <i class="fa fa-print"></i> Print
                    </button>
                </a>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col"> Token
                            </th>
                            <th scope="col">
                                Token Category
                            </th>

                            <th scope="col" >
                                Token Code
                            </th>
                            <th scope="col">
                                Description
                            </th>

                            <th scope="col" >
                                Username
                            </th>

                            <th scope="col" >
                                Reported By
                            </th>
                            <th scope="col" >
                                Contact
                            </th>
                            <th scope="col" class="col">
                                Address
                            </th>
                            <th scope="col" >
                                Assign To
                            </th>

                            <th scope="col" >
                                Created by
                            </th>

                            <th scope="col" >
                                Created by Client
                            </th>
                            <th scope="col" >
                                Status
                            </th>
                            <th scope="col" >
                                Remarks
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($token as $r)
                            <tr>
                                <td>
                                    {{ $r->token }}
                                </td>
                                <td>
                                    {{ $r->tokenCategory }}
                                </td>

                                <td>
                                    {{ $r->tokenCode }}
                                </td>

                                <td>
                                    {{ $r->description }}
                                </td>
                                <td>
                                    {{ $r->userid }}
                                </td>

                                <td>
                                    {{ $r->reportedBy }}
                                </td>

                                <td>
                                    {{ $r->reporterContact }}
                                </td>

                                <td>
                                    Flat No: {{ $r->flat_no}}, 
                                    Building: {{$r->building_name}}, 
                                    Road: {{$r->road_no}},
                                    Sector: {{$r->block_sector}},
                                    Area: {{ $r->area  }}
                                </td>
                                <td>
                                    {{ $r->name }}
                                </td>
                                <td>
                                    {{ $r->username }}
                                </td>
                                <td>
                                    {{ $r->createByClient }}
                                </td>
                                <td>
                                    @if ($r->status == 'Active')
                                        Not Done
                                    @else
                                        Done
                                    @endif
                                </td>
                                <td>
                                    {{ $r->remarks }}
                                </td>
                            </tr>
                        @endforeach
                        <!-- More items... -->
                    </tbody>
                </table>
            </div>

            <div class="p-5">
                {{-- {{ $employees->links() }} --}}
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });
        window.onload = function() {
            window.print();
        }
        window.onfocus = function() {
            window.close();
        }
    </script>

    <style>
        .pop {
            display: none;
        }

        @media print {

            table tr th,
            table,
            tr,
            td {
                font-size: 10px !important;
                padding: 2px !important;
            }
        }

    </style>

@endsection

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#pop').on('change', function() {
                var type = $("#pop").val();
                window.location.href = "{{ route('billSheet') }}" + "?type=" + type;
            });
        });
    </script>
@endsection
