<?php

namespace App\Console\Commands;

use App\Http\Controllers\ExpireCheckController;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class disconnectExpireButOnlineRadiusCustomerCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'disconnect:expireButOnlineRadiusCustomer';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $time = collect(json_decode(siteinfo()->settings))->where('type', 'expire_time')->first()->value ?? '00:00:00';

        if (!checkAPI()) {
            ExpireCheckController::disconnectExpireButOnline($time);
        }


    }
}
