import { Form } from "react-bootstrap";
import _ from "lodash";
import { getColor } from "../../../../../../util/colorModule";

export function ComponentOutput({
    onPortChangeHandler,
    component,
    componentOption,
}) {
    if (!component) return;

    switch (componentOption) {
        case "device":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Port</Form.Label>
                    <Form.Select onChange={onPortChangeHandler}>
                        <option>Select port</option>
                        {component.ports.map((port) => (
                            <option value={port.id} key={port.id}>
                                {port.port_number}: {port.label}{" "}
                                {_.toUpper(port.port_type)}
                                {port.port_stream === "incoming" ? "⬇️" : "⬆️"}
                                {port.connected_component_id || port.fiber_id
                                    ? " - Used"
                                    : " - Available"}
                            </option>
                        ))}
                    </Form.Select>
                </Form.Group>
            );
        case "splitter":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Core</Form.Label>
                    <Form.Select onChange={onPortChangeHandler}>
                        <option>Select Output Core</option>
                        {component?.splitter_out?.map((output_core) => (
                            <option value={output_core.id} key={output_core.id}>
                                {output_core.out_number}:{" "}
                                {getColor(
                                    ((output_core.out_number - 1) % 12) + 1
                                )}{" "}
                                {output_core.connected_component_id ||
                                output_core.fiber_id
                                    ? " - Used"
                                    : " - Available"}
                            </option>
                        ))}
                    </Form.Select>
                </Form.Group>
            );
        case "onu":
            return (
                <Form.Group className="mt-2">
                    <Form.Label>Select Onu Port</Form.Label>
                    <Form.Select onChange={onPortChangeHandler}>
                        <option>Select Onu Interface</option>
                        <option value="ethernet">
                            Ethernet{" "}
                            {component.lan_connected_component_id
                                ? " - Used"
                                : " - Available"}
                        </option>
                        <option value="optical">
                            Optical{" "}
                            {component.optical_connected_component_id
                                ? " - Used"
                                : " - Available"}
                        </option>
                    </Form.Select>
                </Form.Group>
            );
        default:
            return null;
    }
}
