<?php

namespace App\Jobs;

use App\Models\Client;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use App\Http\Controllers\CustomerInvoiceController;

class SendMailFromFilterJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $ids;

    public function __construct($ids)
    {
        $this->ids = $ids;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        $clients = Client::with('clientsinfo', 'packages:id,package_name,package_rate', 'subpack:id,name,rate', 'pop:id,popname,bill_generate,subreseller', 'customerAccount', 'pop.reseller')
            ->selectRaw('id,pop_id,billing_cycle,package_id,userid,password,ip_address,expire_date,payment_dadeline,created_by,client_approval,created_at,clients_status,sub_package_id,customer_id,marketed_by,deleted_at,pop_id')
            ->where('client_approval', 'approved')
            ->whereHas('pops', function ($q) {
                $q->where('bill_generate', 'yes');
            })
            ->whereIn('id', $this->ids)
            ->get();
            
            echo $clients->count();


        foreach ($clients as $client) {
            (new CustomerInvoiceController)->batchSendInvoice($client);
        }
    }
}
