<?php

namespace App\Imports;

use DateTime;
use Exception;
use Throwable;
use Carbon\Carbon;
use App\Models\Nas;
use App\Models\Pop;
use App\Models\Client;
use App\Models\Packages;
use App\Models\SubPackage;
use App\Models\Clientsinfo;
use GuzzleHttp\Promise\Create;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use App\Models\MikcrotikClientList;
use App\Models\ReselleBalanceLogReport;
use Maatwebsite\Excel\Concerns\Importable;
use App\Models\SubResellerBalanceLogReport;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Facade\Ignition\Support\Packagist\Package;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ClientsImport implements ToCollection
{
    use Importable;
    public function collection(Collection $rows)
    {
        // For Static IP

        $count = 0;
        foreach($rows as $row)
        {
            $count++;
            $list_billing_cycle = preg_replace("/[^0-9]/", "", $row[7]);
            $int_billing_cycle = $list_billing_cycle;
            $expire = date('2024-05-' . $int_billing_cycle . ' 00:00:00');
            $today = Carbon::parse(today())->format('Y-m-d 00:00:00');

            if(strtotime($expire) < strtotime($today) ){
                $expire = Carbon::parse($expire)->addMonth();
            }

            // if (is_numeric($row[15])) {
            //     $carbonDate = Carbon::parse(($row[15] - 25569) * 86400)->format('Y-m-d 00:00:00');
            //     $day = Carbon::parse($carbonDate)->format('d');
            // } else {
            //     $carbonDate = Carbon::parse($row[15])->format('Y-m-d 00:00:00');
            //     $day = Carbon::parse($carbonDate)->format('d');
            // }
            // dd($day);

            $pop = Pop::where('popname', $row[6])->first();
            if ($pop == null) {
                dd("pop", $row[6], $row[7], $count);
            }

            $nas = Nas::where('id', $pop->nas_id)->first();

            $ip_block = json_decode($nas->ip_block);

            foreach($ip_block as $ip_block)
            {
                // dd($ip_block);
                $singleIp = trim($row[1]);

                $ips = getStaticIpFromBlock($ip_block->ip_block);
                // dd($ips, $singleIp);
                $block_id = '';
                foreach($ips as $ip)
                {
                    $ip = trim($ip);
                    if($singleIp == $ip)
                    {
                        $block_id = $ip_block->id;
                        // dd($block_id);
                    }
                }

                if($block_id == 0)
                {
                    $block_id = '0';
                }
                if($block_id == '')
                {
                    dd("IP Not Found", $singleIp);
                }
            }



            $package = Packages::where('package_name', $row[4])->first();
            $sub_package = SubPackage::where('name', trim($row[4]))->first();
            if ($pop->subreseller == 'no') {
                if ($package == null) {
                    dd("package", $row[4]);
                }
            }

            if ($pop->subreseller == 'yes') {
                if ($sub_package == null) {
                    dd("sub-package", trim($row[4]));
                }
            }


            $check_client = Client::where('ip_address', trim($row[1]))->first();

            if($check_client == null)
            {
                $client = new Client();
                $client->userid = trim($row[1]);
                $client->ip_address = trim($row[1]);
                $client->password = 'RandomPassword';
                $client->package_id = $package->id;
                $client->pop_id = $pop->id;
                $client->billing_cycle = $int_billing_cycle;
                $client->expire_date = $expire;
                $client->required_cable = 0;
                $client->created_by = auth()->user()->id;
                $client->client_approval = "pending";
                $client->clients_status = "deactive";
                $client->ethernet_port = $block_id;
                $client->isStatic = 1;
                $client->save();
                $client->customer_id = $client->id;
                $client->save();
                $clientInfo = new Clientsinfo();
                $clientInfo->client_id = $client->id;
                $clientInfo->clients_name = $row[2];
                $clientInfo->contact_no = $row[3];
                if (is_numeric($row[13])) {
                    $clientInfo->joinDate = Carbon::parse(($row[13] - 25569) * 86400)->format('Y-m-d 00:00:00');
                } else {
                    if (isset($row[13])) {
                        $clientInfo->joinDate = Carbon::createFromFormat('d/m/Y', $row[13])->format('Y-m-d 00:00:00');
                    } else {
                        $clientInfo->joinDate = Carbon::parse(today())->format('Y-m-d 00:00:00');
                    }
                }

                // $clientInfo->email = $row[8] ?? "";
                // $clientInfo->father_name = $row[9];
                // $clientInfo->mother_name = $row[10];
                // $clientInfo->area = $row[11];
                // $clientInfo->remarks = $row[12] ?? "";
                // $clientInfo->building_no = $row[13];
                // $clientInfo->flat_no = $row[14];
                $clientInfo->save();
            }

        }
    }
}
