import _ from 'lodash';
import { Col, Container, Row, Table } from 'react-bootstrap';

const CableDetail = ({ cableDetail }) => {
    return (
        <Container fluid>
            {' '}
            <Row>
                <Col className='bg-light rounded' lg={6}>
                    <Table striped bordered hover className='mt-3'>
                        <tbody>
                            <tr>
                                <td>Cable Id</td>
                                <td>{cableDetail.id}</td>
                            </tr>
                            <tr>
                                <td>Start Node</td>
                                <td>
                                    {cableDetail?.start_node.id}.{' '}
                                    {cableDetail?.start_node.name} (
                                    {_.upperFirst(cableDetail?.start_node.type)}
                                    )
                                </td>
                            </tr>
                            <tr>
                                <td>End Node</td>
                                <td>
                                    {cableDetail?.end_node.id}.{' '}
                                    {cableDetail?.end_node.name} (
                                    {_.upperFirst(cableDetail?.end_node.type)})
                                </td>
                            </tr>
                            <tr>
                                <td>Cable Distance</td>
                                <td>{cableDetail.cable_distance} Meters</td>
                            </tr>
                            <tr>
                                <td>Cable Length</td>
                                <td>{cableDetail.cable_length} Meters</td>
                            </tr>
                            <tr>
                                <td>Fiber/Tube</td>
                                <td>
                                    {cableDetail.fiber_count}/
                                    {cableDetail.tube_count}
                                </td>
                            </tr>

                            <tr>
                                <td>Remarks</td>
                                <td>{cableDetail.remarks}</td>
                            </tr>
                        </tbody>
                    </Table>
                </Col>
            </Row>
        </Container>
    );
};

export default CableDetail;
