@extends('layout.app')


@section('content')


    <form action="{{ route('item-return.update',$itemReturn) }}" method="POST" id="itemReturnForm">
        @method('put')
        @csrf

        <div class="card">
            <div class="card-body">

                <input type="hidden" id="item_return_id" name="id" value="{{$itemReturn->id}}">

                <div class="form-group">
                    <label for="supplier_id" class="">
                        Category
                    </label>

                    <select name="category_id" id="category_id" class="form-control">
                        <option value="">Select Category</option>
                        @foreach ($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                        @endforeach
                    </select>

                </div>

                <div class="form-group">
                    <label for="product_id" class="">
                        Item
                    </label>

                    <select name="product_id" id="product_id"  class="form-control">
                        <option value="">Select Item</option>

                    </select>
                </div>


                <div>

                    <button class="btn bg-primary float-right mb-2" id="addProduct" >Add</button>
                </div>

                <div class=" mt-2" id="forTable">
                    <div class="row mt-2">

                        <div class="form-group col-md-6">
                            <label for="product_id" class="">  Reason </label>
                            <input type="text" class="form-control" id="reason" name="reason" value="{{$itemReturn->reason}}" autocomplete="off" required>
                        </div>

                        <div class="form-group  col-md-3">
                            <label for="supplier_id" class="">
                                Select Employee
                            </label>

                            <select name="employee_id" id="employee_id" class="form-control" required>
                                <option value="">Select Employee</option>
                                @foreach ($employees as $employee)
                                    <option value="{{ $employee->id }}" @if ($itemReturn->employee_id==$employee->id)
                                        selected
                                    @endif>{{ $employee->name }}</option>
                                @endforeach
                            </select>


                        </div>
                        <div class="form-group  col-md-3">
                            <label for="supplier_id" class="">
                                Select branch
                            </label>

                            <select name="branch_id" id="branch_id" class="form-control" required>
                                <option value="">Select Branch</option>
                                @foreach ($branches as $branche)
                                    <option value="{{ $branche->id }}" @if ($itemReturn->branch_id==$branche->id)
                                        selected
                                    @endif>{{ $branche->name }}</option>
                                @endforeach
                            </select>


                        </div>
                        <div class="form-group  col-md-3">
                            <label for="supplier_id" class="">
                                Serial Number Add/Not
                            </label>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="serilNumberAddorNot" id="1" value="yes" @if ($itemReturn->serial_add_or_not=="yes") checked  @endif >
                                <label class="form-check-label" for="flexRadioDefault1">
                                    Serial Number All ready Added
                                </label>
                              </div>
                              <div class="form-check">
                                <input class="form-check-input" type="radio" name="serilNumberAddorNot" id="2" value="no"  @if ($itemReturn->serial_add_or_not=="no") checked  @endif >
                                <label class="form-check-label" for="flexRadioDefault2">
                                    Serial Number previously Not Add
                                </label>
                              </div>


                        </div>

                    </div>
                    <table id="tableId" class="table">
                        <thead>
                            <th>Name</th>
                            <th>Quantity</th>
                            <th>Serial Number</th>
                            <th>Action</th>
                        </thead>
                        <tbody>
                            <tr style="display: none">
                                <td>
                                    <input type="text" data-role="tagsinput">
                                </td><td>
                                    <input type="text" data-role="tagsinput">
                                </td><td>
                                    <input class="serialNumber" type="text" data-role="tagsinput">
                                </td>
                            </tr>

                            @foreach ($itemReturn->item as $item)
                                <tr>
                                    <td style="padding-left: 2px "> {{$item->product->name}} <input style="width: 80px" min=0 class="productId" value="{{$item->product->id}}"  type="hidden"  name="productId[]" step=".0001" required></td>
                                    <td style="padding-left: 2px; align: center"><input class="qty" value="{{$item->qty}}" type="number"  name="qty[]" min=0 required autocomplete="off"> </td>
                                    <td ><input style="width: 100px" class="serialNumber" type="text" value="{{$item->serial_no}}" data-role="tagsinput" name="serialNumber[]" autocomplete="off"> </td>
                                    <td ><lable style="width: 40px" id="btnCancle" step=".01" class="btn btn-danger ">-</lable></td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>


                    <button class="btn bg-info float-right" id="saveBtn" >Save</button>
                </div>


            </div>
        </div>
    </form>



@endsection
@push('js')
{{-- <link rel="stylesheet" href="{{ asset('/')}}css/toastr.min.css"> --}}
<link rel="stylesheet" type="text/css" href="{{ asset('/')}}css/tagsinput.css" crossorigin="anonymous" referrerpolicy="no-referrer">
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" integrity="sha512-xmGTNt20S0t62wHLmQec2DauG9T+owP9e6VU8GigI0anN7OXLip9i7IwEhelasml2osdxX71XcYm6BQunTQeQg==" crossorigin="anonymous" referrerpolicy="no-referrer" /> --}}
    <style type="text/css">
        .bootstrap-tagsinput {
            width: 100%;
        }

        .label-info {
            background-color: #17a2b8;
        }

        .label {
            display: inline-block;
            padding: .25em .4em;
            font-size: 75%;
            font-weight: 700;
            line-height: 1;
            text-align: center;
            white-space: nowrap;
            vertical-align: baseline;
            border-radius: .25rem;
            transition: color .15s ease-in-out, background-color .15s ease-in-out,
            border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }

    </style>
<script src="{{ asset('/')}}js/tagsinput.js"></script>
<script src="{{ asset('/')}}js/jquery.validate.js"></script>
{{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.js" integrity="sha512-VvWznBcyBJK71YKEKDMpZ0pCVxjNuKwApp4zLF3ul+CiflQi6aIJR+aZCP/qWsoFBA28avL5T5HA+RE+zrGQYg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script> --}}

<script>
$(document).ready(function() {

    $('#saveBtn').click(function (e) {
        lessCheck=0;
        $("tr .qty").each(function(index,value){
            currentqty=parseFloat($(this).val());
            var serialNumber=$(this).parents("tr").find( "input.serialNumber").val();
            myArray = serialNumber.split(",");
           if(currentqty<myArray.length)
           {
            lessCheck=1;
            // console.log('comes');
           }
        });
        e.preventDefault();
        if(lessCheck==0){
            $('#itemReturnForm').valid();
            $('#itemReturnForm').submit();
        }else{
            toastr.error("Please do not Add Serial Number more than quantity");

        }
        // $('#itemReturnForm').submit();
    });

    $("#tableId").on("click", "#btnCancle", function() {
        $(this).closest("tr").remove();
    });

    $('#addProduct').on('click', function (e) {
        e.preventDefault();
        product =$('#product_id').val();
        var productName = $('#product_id').find(":selected").text();
        $('.serialNumber').tagsinput('refresh');
        if(product){
            $('#forTable').removeClass("d-none");
            check=0;
            $("tr .productId").each(function(index,value){
                currentId=parseFloat($(this).val());
                if(currentId==product){
                    check=1;
                }

            });
            if(check==0){

                $('#tableId tbody').append('<tr >' +
                    '<td style="padding-left: 2px "> '+productName+' <input style="width: 80px" min=0 class="productId" value="'+product+'"  type="hidden"  name="productId[]" step=".0001" required></td>' +
                    '<td style="padding-left: 2px; align: center"><input class="qty" value="" type="number"  name="qty[]" min=0 required autocomplete="off"> </td>' +
                    '<td ><input style="width: 100px" class="serialNumber" type="text" data-role="tagsinput" name="serialNumber[]" autocomplete="off"> </td>' +
                    '<td ><lable style="width: 40px" id="btnCancle" step=".01" class="btn btn-danger ">-</lable></td>' +
                    +'</tr>'
                );
                $('.serialNumber').tagsinput('refresh');

            }else{
                toastr.info("Product allready added");
            }

        }
    });

    $('#category_id').change(function () {
        var id=$('#category_id').val();

        $.ajax({
            url: "{{route('get-item')}}",
            type: 'get',
            data: {data: id},
            success: function (result) {
                $('#product_id').find('option').remove().end().append('<option value="">Select Item</option>');

                $.each(result,function(key, value)
                {
                    $("#product_id").append('<option value=' + value.id + '>' + value.name + '</option>');
                });
            }
        });
    });

    $('#itemReturnForm').on('keydown', 'input', function(event) {

        if (event.which == 13) {
            event.preventDefault();

        }

    });

});
</script>

@endpush

