<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <form action="" id="search">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="<?php echo e($start->format('m/d/y')); ?>"
                                    class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker"
                                    data-target="#searchFrom" autocomplete="off">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>

                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="<?php echo e($end->format('m/d/y')); ?>"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">

                            </div>


                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Select Manager </label>
                            <select name="reseller_id" id="reseller_id" class="select2 form-control">
                                <option value="">All Manager </option>

                                <?php $__currentLoopData = $reseller; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reseller_balance_log_with_pop')): ?>
                        <div class="col-md-3">
                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'> POP Name </label>


                            <select name="pop" id="pop" class="form-control select2">
                                <option value=""> ALL POP</option>
                            </select>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Username</label>
                            <input type="text" name="username" class="form-control">
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group float-right">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>


                </div>

                <div id="result">
                    
                </div>


            </form>
        </div>
    </div>

    
<?php $__env->stopSection(); ?>




<?php $__env->startSection('ajax'); ?>
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
            });
            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('#processing').show();
                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('resellerBalanceLogReport')); ?>',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#processing').hide();

                    }
                });
            });
            $('#reseller_id').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('getResellerPopList')); ?>',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#loading').remove();
                    }
                });
            });
        });
    </script>

    <script>
        function export2csv() {
            let data = "";
            const tableData = [];
            const rows = document.querySelectorAll("table#tableId tr");
            for (const row of rows) {
                const rowData = [];
                for (const [index, column] of row.querySelectorAll("th, td").entries()) {
                    // To retain the commas in the "Description" column, we can enclose those fields in quotation marks.
                    if ((index + 1) % 3 === 0) {
                        rowData.push('"' + column.innerText + '"');
                    } else {
                        rowData.push(column.innerText);
                    }
                }
                tableData.push(rowData.join(","));
            }
            data += tableData.join("\n");
            const a = document.createElement("a");
            a.href = URL.createObjectURL(new Blob([data], {
                type: "text/csv"
            }));
            a.setAttribute("download", "data.csv");
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/rk/radius-circle/resources/views/resellerBalanceLog/index.blade.php ENDPATH**/ ?>