<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\Exportable;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class DeactiveExport implements FromCollection, WithHeadings, ShouldAutoSize, WithEvents, WithColumnWidths, WithStyles, WithCustomStartCell
{
    use Exportable;

    public function headings(): array
    {
        return [
            [
                'Deactive User List',
            ],
            [
                'Sl No',
                'CID',
                'Username',
                // 'password',
                // 'Status',
                // 'Expire',
                // 'B Cycle',
                // 'Package',
                'Name',
                'Contact No',
                'POP',
                // 'NID',
                // 'Customer Info',
                'Area',
                // 'Cable Type',
                'Activation Date',
                'Expire Date',
                'Deactivation Date',
                // 'J Date',
                'Reason',
                'Details',
                // 'Balance',
                // 'Email'
                'MRC',
                'OTC',
                'Due Amount'
            ]
        ];
    }
    protected $data;

    function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        $slNo = 1;
        $items = [];
        foreach ($this->data['list'] as $client) {

            if (isset($this->data['deactive_user'][$client->id])) {

                if ($client->subpack) {
                    $speed = $client->subpack->name;
                    $mrc = $client->subpack->rate ?? 0;
                } else {
                    $speed = $client->packages->package_name;
                    $mrc = $client->packages->package_rate ?? 0;
                }

                $client_info  = $client->clientsinfo->flat_no . " " ?? '';
                $client_info .= $client->clientsinfo->building_name . " " ?? '';
                $client_info .= $client->clientsinfo->building_no . " " ?? '';
                $client_info .= $client->clientsinfo->road_name . " " ?? '';
                $client_info .= $client->clientsinfo->block_sector . " " ?? '';
                $client_info .= $client->clientsinfo->box . " " ?? '';
                $client_info .= $client->clientsinfo->olt_pon . " " ?? '';

                if (isset($client->customerAccount->dueAmount)) {
                    $balance = $client->pop->bill_generate == "yes" ? (string)($client->customerAccount->dueAmount) : "0";
                } else {
                    $balance = "0";
                }

                $items[] = [
                    $slNo++,
                    $client->id,
                    $client->userid,
                    $client->clientsinfo->clients_name,
                    // $client->password,
                    // $client->clients_status,
                    // $client->expire_date ? date('Y-m-d', strtotime($client->expire_date)) : '',
                    // $client->billing_cycle,
                    // $speed,
                    $client->clientsinfo->contact_no ?? '',
                    $client->pop->popname,
                    $client->clientsinfo->area ?? '',
                    $client->created_at ? date('Y-m-d', strtotime($client->created_at)) : '',
                    $client->expire_date ? date('Y-m-d', strtotime($client->expire_date)) : '',
                    $this->data['deactive_user'][$client->id]->created_at ? date('Y-m-d', strtotime($this->data['deactive_user'][$client->id]->created_at)) : '',
                    // $client->clientsinfo->national_id ?? '',
                    '',
                    $client->clientsinfo->remarks ?? '',
                    // $client_info,

                    // $client->clientsinfo->cable_type ?? '',
                    //  $client->clientsinfo->joinDate ? date('Y-m-d', strtotime($client->clientsinfo->joinDate)) : '',

                    // $client->clientsinfo->email ?? '',
                    $mrc,
                    $client->clientsinfo->otc,
                    $balance,
                ];
            }
        }
        // dd($items);
        return collect($items);
    }

    public function registerEvents(): array
    {
        return [

            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->mergeCells('A1:K1')->getStyle('A1:K1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                            'color' => ['argb' => 'EB2B02'],
                        ],
                    ],
                    'font' => [
                        'name'      =>  'Calibri',
                        'size'      =>  15,
                        'bold'      =>  true,
                        'color' => ['argb' => 'EB2B02'],
                    ],
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'startColor' => [
                            'rgb' => 'dff0d8',
                        ]
                    ],
                ])->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);

                $event->sheet->getStyle('A2:K2')->applyFromArray([
                    'font' => [
                        'bold' => true,
                    ],
                    'borders' => [
                        'outline' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ],
                    ],
                    'font' => [
                        'name'      =>  'Calibri',
                        'size'      =>  12,
                    ],
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                        'startColor' => [
                            'rgb' => 'dff0d8',
                        ]
                    ],
                ]);
            },
        ];
    }

    public function startCell(): string
    {
        return 'A1';
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1    => ['font' => ['bold' => true]],
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 50,
            'B' => 11,
            'C' => 11,
            'D' => 13,
            'E' => 36,
            'F' => 33,
            'G' => 15,
            'H' => 15,
            'I' => 15,
            'J' => 15,
            'K' => 15,
        ];
    }
}
