@extends('layout.app')


@section('content')
    <form action="{{ route('crm-item-return-approve') }}" method="POST">

        @csrf
        <div class="card">
            <div class="card-body">
                <a class="btn bg-purple" href="{{ route('crm-list', "Store") }}">Back To CRM </a>
                <input type="hidden" id="client_id" name="client_id" value="{{$client_id}}">

                <table class="table table-bordered mt-3">
                    <thead class="table-dark">
                        <tr>
                            <th style="width: 40%">Item Name</th>
                            <th style="width: 20%">Quantity</th>
                            <th>Return Status</th>
                            <th>Approve Status</th>
                        </tr>
                    </thead>
                    <tbody id="item_list">
                        @foreach ($crm_return_items as $key=>$item)

                            <tr>
                                <td >
                                    {{$item->item->name}}
                                    <input type="hidden" name="item_id[]" id="item_id" value="{{$item->crm_item_id}}" required class="form-control" placeholder=" Name" autocomplete="off">
                                    <input type="hidden" name="crm_return_item_id[]" id="crm_return_item_id" value="{{$item->id}}" required class="form-control" placeholder=" Name" autocomplete="off">
                                </td>
                                <td >
                                   {{$item->quantity}}
                                </td>
                                <td>
                                     {{$item->status}}
                                </td>
                                 <td>
                                     {{$item->approve_status}}
                                </td>


                            </tr>
                        @endforeach
                    </tbody>
                </table>
                 <span class="text-danger text-md badge"> Note : After Apporve A good product will be added to stock. So please check every item carefully. We cannot revert this action.</span>
                <div class="form-group">
                    <button type="submit" class="btn btn-success float-right">
                        Approved All
                    </button>
                </div>
            </div>
        </div>
    </form>

    <div class="p-5"></div>
    <style>
        .form-control {
           width: auto !important
        }

        .card{
            width: auto !important;
        }
    </style>
@endsection

@push('js')

    <script>
        $(document).ready(function() {
            $(document).on("change", "#item_id", function() {

                var item_id = $(this).val();
                var item_name = $("#item_id option:selected").text();

                let row = ` <tr>
                            <td >
                                ${item_name}
                                <input type="hidden" name="item_id[]" id="item_id" value="${item_id}" required class="form-control" placeholder=" Name" autocomplete="off">
                            </td>
                            <td >
                                <input type="number" step=".01" name="item_quantity[]" id="item_quantity" value="1" min="1" required class="form-control" placeholder="Quantity" autocomplete="off">
                            </td>
                            <td>
                                <select name="item_return_status[]" id="item_return_status" class="form-control" required>
                                    <option value="Good">Good</option>
                                    <option value="Damage">Damage</option>
                                    <option value="Lost">Lost</option>
                                </select>
                            </td>
                            <td>
                                <button type="button" class="btn btn-danger btn-sm remove_item" >
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>`;

                $("#item_list").append(row);
            });

            $(document).on("click", ".remove_item", function() {
                $(this).closest("tr").remove();
            });


       });
    </script>
@endpush
