<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOnuMapTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('onu_map', function (Blueprint $table) {
            $table->id();
            $table->timestamps();

            $table->string("name")->nullable();
            $table->string("serial_number")->nullable();
            $table->string("mac_address")->nullable();
            $table->string("manufactures")->nullable();
            $table->string("model")->nullable();
            $table->string("remarks")->nullable();
            $table->string("type")->default("onu");

            $table->foreignId("cluster_id");

            $table->foreignId("cable_id")->nullable();
            $table->foreignId("fiber_id")->nullable();


            $table->string("optical_connected_component_type")->nullable();
            $table->foreignId("optical_connected_component_id")->nullable();

            $table->string("lan_connected_component_type")->nullable();
            $table->foreignId("lan_connected_component_id")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('onu_map');
    }
}
