<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBankTransfarsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bank_transfars', function (Blueprint $table) {
            $table->id();
            $table->integer('account_id');
            $table->string('check_no')->nullable();
            $table->integer('diposit_amount')->nullable();
            $table->integer('withdraw_amount')->nullable();
            $table->longText('description');
            $table->string('by');
            $table->tinyInteger('status')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bank_transfars');
    }
}
