<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSplitterMapTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('splitter_map', function (Blueprint $table) {
            $table->id();
            $table->timestamps();

            $table->string("name");
            $table->foreignId("cluster_id");
            $table->string("type")->default("splitter");

            $table->foreignId("cable_id")->nullable();
            $table->foreignId("fiber_id")->nullable();

            $table->string("connected_component_type")->nullable();
            $table->foreignId("connected_component_id")->nullable();

            $table->foreignId("port_id")->nullable();

            $table->integer("split_ratio");
            $table->integer("used")->default(0);

            $table->string("remarks")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('splitter_map');
    }
}
