<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ClientSourceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $source = [
            ['id' => '1', 'name' => '1st Visit'],
            ['id' => '2', 'name' => 'Follow Up'],
            ['id' => '3', 'name' => 'Leaflet'],
            ['id' => '4', 'name' => 'FB SMS'],
            ['id' => '5', 'name' => 'FB Post'],
            ['id' => '6', 'name' => 'Existing Client Reference'],
            ['id' => '7', 'name' => 'Gate Board'],
            ['id' => '8', 'name' => 'Guard Reference'],
            ['id' => '9', 'name' => 'Relatives & Friends'],
            ['id' => '10', 'name' => 'Sticker'],
            ['id' => '11', 'name' => 'FTP'],
            ['id' => '12', 'name' => 'Festoon'],
            ['id' => '13', 'name' => 'SMS'],
            ['id' => '14', 'name' => 'Personal FB Post'],
        ];

        foreach ($source as $item) {

            unset($item['id']);

            if (DB::table('client_sources')->where('name', $item['name'])->count() < 1) {

                DB::table('client_sources')->insert($item);
            }
        }
    }
}
