@extends('layout.app')
@section('content')
    <form action="{{ route('mikrotiks.store') }}" method="POST">

        @csrf

        <div class="card">
            <div class="card-body">
                <div class="form-group">
                    <label for="shortname" class="block text-sm font-medium text-gray-700">
                        Mikrotik Name <span style="color: red;">*</span>
                    </label>
                    <input type="text" name="shortname" id="shortname" value="{{ old('shortname') }}" class="form-control"
                        placeholder="Mikrotik Name" autocomplete="off" required>
                    @error('shortname')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="nasname" class="block text-sm font-medium text-gray-700">
                        Mikrotik IP <span style="color: red;">*</span>
                    </label>
                    <input type="text" name="nasname" id="nasname" class="form-control" placeholder="Mikrotik IP"
                        value="{{ old('nasname') }}" autocomplete="off" required>
                    @error('nasname')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                @if (!checkAPI())
                <div class="form-group">
                    <label for="secret" class="block text-sm font-medium text-gray-700">
                        Secret <span style="color: red;">*</span>
                    </label>
                    <input type="text" name="secret" id="secret" class="form-control" placeholder="Mikrotik Radius Secret"
                        value="{{ old('secret') }}" autocomplete="off" required>
                    @error('secret')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                    <div class="form-group">
                        <label for="secret" class="block text-sm font-medium text-gray-700">
                            Secret*
                        </label>
                        <input type="text" name="secret" id="secret" class="form-control"
                            placeholder="Mikrotik Radius Secret" value="{{ old('secret') }}" autocomplete="off" required>
                        @error('secret')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                @endif
                <div class="form-group">
                    <label for="secret" class="block text-sm font-medium text-gray-700">
                        Mikrotik User Name
                    </label>
                    <input type="text" name="mickrotik_user_name" id="mickrotik_user_name" class="form-control" value="{{ old('mickrotik_user_name') }}"
                        placeholder="Mikrotik user name" autocomplete="off">
                    @error('secret')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror

                </div>

                <div class="form-group">
                    <label for="secret" class="block text-sm font-medium text-gray-700">
                        Mikrotik Password
                    </label>
                    <input type="text" name="mickrotik_user_password" id="mickrotik_user_password" class="form-control" value="{{ old('mickrotik_user_password') }}"
                        placeholder="Mikrotik user password" autocomplete="off">
                    @error('secret')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror

                </div>

                <div class="form-group">
                    <label for="secret" class="block text-sm font-medium text-gray-700">
                        Mikrotik Port
                    </label>
                    <input type="text" name="mickrotik_port" id="mickrotik_port" class="form-control" value="{{ old('mickrotik_port') }}"
                        placeholder="Mikrotik Port" autocomplete="off">
                    @error('secret')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror

                </div>


                <div class="form-group">
                    <label for="about" class="block text-sm font-medium text-gray-700">
                        Description <span style="color: red;">*</span>
                    </label>
                    <textarea id="about" name="description" rows="3" class="form-control"
                        placeholder="Description" required>{{ old('description') }}</textarea>

                    @error('description')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror

                </div>
                @if (checkSettings('static_ip_manage') == 'enable')
                    <div class="form-group">
                        <h6>Static Ip Block</h6> <button id="addIpBlock" class="btn btn-info" style="float: right">Add</button>

                        <div class="row">
                            <div class="col-md-12">

                                <table id="ip_block" class="table table-bordered">
                                    <thead class="thead-dark">
                                        <th>Port</th>
                                        <th>Ip Block</th>
                                        <th></th>
                                    </thead>
                                    <tbody>
                                        {{-- <tr>
                                                <td style="width: 30%"><input type="text" name="port[]" class="form-control " required></td>
                                                <td style="width: 65%"><input type="text" name="ip_block[]" class="form-control " required></td>
                                                <td style="width: 5%"></td>
                                            </tr> --}}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Save
                    </button>
                </div>
            </div>
        </div>

    </form>
@endsection

@push('js')
    <script>
        $(document).ready(function() {
            $('#addIpBlock').click(function() {
                var html = '<tr>';
                html += '<td><input type="text" name="port[]" class="form-control " placeholder="Ethernet Interface" required></td>';
                html += '<td><input type="text" name="ip_block[]" class="form-control " placeholder="IP Block" required></td>';
                html +=
                    '<td><button type="button" name="remove" class="btn btn-danger btn-sm remove"><i class="fa fa-minus"></i></button></td></tr>';
                $('#ip_block').append(html);
            });

            $(document).on('click', '.remove', function() {
                $(this).closest('tr').remove();
            });

        });
    </script>
@endpush
