<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResellerBillPayment extends Model
{
    use HasFactory;

    public function paymentBy()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id', 'id');
    }

    public function reseller()
    {
        return $this->belongsTo(Reseller::class, 'reseller_id', 'id');
    }

    public function clientsInfo()
    {
        return $this->belongsTo(Clientsinfo::class, 'client_id', 'client_id');
    }
}
