<?php

namespace App\Models\map;

use App\Models\Client;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Onu extends Model
{
    use HasFactory;
    protected $table = "onu_map";

    protected $fillable = [
        "name",
        "serial_number",
        "manufactures",
        "model",
        "remarks",
        "type",
        "mac_address",

        "cluster_id",

        "cable_id",
        "fiber_id",

        "optical_connected_component_type",
        "optical_connected_component_id",

        "lan_connected_component_type",
        "lan_connected_component_id",
    ];

    public function opticalConnectedComponent()
    {
        return $this->morphTo(null, 'optical_connected_component_type', 'optical_connected_component_id');
    }

    public function lanConnectedComponent()
    {
        return $this->morphTo(null, 'lan_connected_component_type', 'lan_connected_component_id');
    }

    public function fiber()
    {
        return $this->belongsTo(Fiber::class, "fiber_id");
    }

    // this is only for handling error in relation
    public function device()
    {
        return $this->belongsTo(Device::class, "garbage_id");
    }
    // added this because of relation error
    public function splitter()
    {
        return $this->belongsTo(Splitter::class, "garbage_id");
    }
    public function client()
    {
        return $this->belongsTo(Client::class, "garbage_id");
    }
}
