@extends('layout.app')


@section('content')
    <div class="mt-2 card">
        <div class=" card-body">

            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered">
                    <thead class="bg-dark">
                        <tr>
                            <th style="padding-left: 2px;padding-right: 2px;">ID</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:150px">Client</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:90px">Date To execute</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:100px">Status</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:120px">Package</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:120px">Description</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:120px">Schedule By</th>
                            <th style="padding-left: 2px;padding-right: 2px;max-width:70px"></th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($lists as $item)
                            <tr>
                                <td>{{$item->id}}</td>
                                <td>{{$item->client->userid}}</td>
                                <td>{{$item->schedule_date}}</td>
                                <td>{{$item->status}}</td>
                                <td>

                                    @if ($item->client->pop->subreseller == 'yes')
                                        {{$item->newSubPackage->name}}
                                    @else
                                        {{$item->newPackage->package_name}}
                                    @endif
                                </td>
                                <td>
                                    {{$item->process_description}}
                                </td>
                                <td>{{$item->scheduleBy->name}}</td>
                                <td>


                                    <form action="{{ route('schedule-package-change-destroy') }}" method="POST"
                                        style="margin-top: 14px !important;">
                                        @csrf
                                        <input type="hidden" value="{{$item->id}}" name="id">

                                        <button type="submit" class="btn border bg-danger "
                                            onclick="return confirm('Are you sure to delete it?')"
                                            data-toggle="tooltip" data-placement="bottom" title="Delete"> <span>
                                                <i class="fa-solid fa-trash-can text-light"></i></span> </button>
                                    </form>

                                </td>

                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>

    </div>
    <style>
        .sub-menu li {
            font-size: 1em;
            padding: .25em 1em;
            line-height: 1em;
        }

        .sub-menu {
            padding: 0;
            max-height: 200px;
            /* 1.5 x 3 */
            overflow-y: auto;
        }

        li.selected {
            background: #17A2B8 !important;
        }
    </style>
@endsection

@section('ajax')
<script>
    $(document).ready(function() {


    });
</script>
@endsection
