<?php

namespace App\Services;

use App\Models\FundTransfer;
use Carbon\Carbon;
use App\Models\ResellerCommissionReference;
use App\Models\SubResellerCommissionReference;

class FundTransferService
{

  public function addFundToCash($amount,$note,$accounting_id,$transfer_type)
  {
    FundTransfer::create([
      'fund_send_by'          => 0,
      'fund_received_by'      => 0,
      'note'                  => $note,
      'transfer_by'           => auth()->user()->id,
      'amount'                => $amount,
      'user_accountings_id'   => $accounting_id, //this will use for income or expense table reference
      'transfer_type'         => $transfer_type
    ]);
  }

  public function modifyAddFundToCash($amount,$note,$accounting_id,$transfer_type)
  {
    FundTransfer::where('user_accountings_id',$accounting_id)->update([
      'fund_send_by'          => 0,
      'fund_received_by'      => 0,
      'note'                  => $note,
      'transfer_by'           => auth()->user()->id,
      'amount'                => $amount,
      'user_accountings_id'   => $accounting_id, //this will use for income or expense table reference
      'transfer_type'         => $transfer_type
    ]);
  }
}
