@extends('layout.app')

@section('content')

    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="resellerRechargeLog">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Reseller</label>
                            <select name="reseller" id="reseller" class="form-control form-control-sm">
                                <option value="">Select One</option>
                                {{-- @if (auth()->user()->hasRole('Admin')) --}}


                                {{-- @else
                                    <option value="{{ $auth_reseller->id }}">{{ $auth_reseller->name }}</option>
                                @endif --}}
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label> Select POP </label>
                        <select name="pop" id="pop" class="form-control form-control-sm">
                            <option value="all"> Select One</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group float-right mt-4">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>

                {{-- <div id="result">

                </div> --}}

            </form>


        </div>
    </div>


    <div class="mt-2 card">
        <div class="card-body">
            <div id="customer_list_body">
                <div id="result" class="table-responsive" style="">
                    <h4>Total Online: </h4>
                    <table id="dataTable" class="table table-bordered">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col"> User ID </th>
                                <th scope="col"> Client IP </th>
                                <th scope="col"> MAC Address </th>
                                <th scope="col"> Uptime </th>
                                <th scope="col"></th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">

                            @foreach ($list as $r)
                                {{-- {{dd($r)}} --}}
                                <tr>
                                    <td>
                                        {{ $r->username }}
                                    </td>
                                    <td>
                                        {{ $r->framedipaddress }}
                                    </td>

                                    <td>
                                        {{ $r->callingstationid }}
                                    </td>

                                    <td>
                                        {{ \Carbon\Carbon::parse($r->acctstarttime)->diffForHumans() }}
                                    </td>



                                    <td class="px-6 text-center text-sm font-medium">

                                        <form class="inline-block" action="{{ route('userDisconnect', $r->username) }}"
                                            method="post">
                                            @csrf
                                            <input type="hidden" value="{{ $r->username }}">
                                            <input type="submit" class="inline-block btn-blue mb-2" value="Disconnect">
                                        </form>

                                        {{-- <a href="{{ route('refreshSession', $r->username) }}"
                                            class="inline-block  py-1 px-2 border rounded bg-red-300 text-white">Refresh
                                            Session</a> --}}
                                    </td>
                                </tr>

                            @endforeach

                            <!-- More items... -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="card-footer">
        </div>
    </div>

    <style>
        div#processing {
            display: none;
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media print {
            a {
                text-decoration: none !important;
                color: #222 !important;
            }

            th {
                font-size: 10px !important;
                padding: 2px !important;
                text-align: center;
            }

            tr {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            td {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            table {
                width: 100%;
            }

            .shadow {
                box-shadow: none;
            }

            tr th:last-child {
                display: none !important;
            }

            tr td:last-child {
                display: none !important;
            }

        }

    </style>


@endsection

@section('ajax')

    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('#pop').html('<option value="all">Select One</option>');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('onlineCustomerSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#processing').remove();

                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                    }
                });
            });

        });
    </script>

@endsection
