<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Invoice NC300303</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #000;
            margin: 40px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .header h1 {
            font-size: 36px;
            margin-bottom: 0;
        }

        .invoice-info {
            text-align: right;
            font-size: 14px;
        }

        .section {
            margin-top: 30px;
        }

        .contact-info,
        .issued-to {
            font-size: 14px;
            line-height: 1.6;
        }

        .issued-to {
            text-align: right;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 30px;
            font-size: 14px;
        }

        table th,
        table td {
            border: 1px solid #000;
            padding: 10px;
            text-align: left;
        }

        table th {
            background: #000;
            color: #fff;
            font-weight: bold;
        }

        .totals {
            margin-top: 20px;
            width: 100%;
            font-size: 14px;
        }

        .totals td {
            padding: 5px 10px;
            text-align: right;
        }

        .totals .label {
            text-align: left;
        }

        .bold {
            font-weight: bold;
        }

        .signature {
            margin-top: 60px;
            font-size: 14px;
        }

        .signature-line {
            width: 200px;
            border-top: 1px solid #000;
            margin-bottom: 5px;
        }

        .thank-you {
            text-align: right;
            font-size: 15px;
            font-weight: bold;
            color: #bfbfbf;
            line-height: 1;
            margin-top: 20px;
        }
    </style>
</head>

<body>

    <div class="header">
        <h1>INVOICE</h1>
        <div class="invoice-info">
            <p><strong>INVOICE NO : </strong>{{ $invoice->invoice_no }}</p>
            <p><strong>Date Issued:</strong><br>{{ date('d-M-Y', strtotime($invoice->billing_date ?? '')) }}</p>
            <p><strong>Issued
                    to:</strong><br>{{ $invoice->bandwidthSaleCustomer->customer_name ?? '' }}<br>{{ $invoice->bandwidthSaleCustomer->phone ?? '' }}<br>{{ $invoice->bandwidthSaleCustomer->address ?? '' }}
            </p>
        </div>
    </div>
    @php
        $company_info = siteinfo();
    @endphp
    <div class="section">
        <div class="contact-info">
            <strong>Contact Info:</strong><br>
            {{ $company_info->name }}<br>
            {{ $company_info->email }}<br>
            {{ $company_info->mobile }}
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>DESCRIPTION OF SERVICES</th>
                <th>RATE</th>
                <th>VAT</th>
                <th>TOTAL(BDT)</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($invoice->sateItems as $item)
                <tr>
                    <td><strong>{{ $item->service->name ?? '' }}</strong> ({{ $item->quantity ?? '' }} MB)
                        {{ date('d-M-Y', strtotime($item->from_date ?? '')) }} to
                        {{ date('d-M-Y', strtotime($item->to_date ?? '')) }}</td>
                    <td style="text-align: right;">{{ number_format($item->rate, 2) }}</td>
                    <td style="text-align: right;">{{ number_format($item->vat, 2) }}</td>
                    <td style="text-align: right;">{{ number_format($item->line_total, 2) }}</td>
                </tr>
            @empty
            @endforelse
        </tbody>
        <tr>
            <td colspan="3" class="label" style="text-align: right;">SUB TOTAL</td>
            <td style="text-align: right;">{{ number_format($invoice->total, 2) }}</td>
        </tr>
        <tr>
            <td colspan="3" class="label" style="text-align: right;">DISCOUNT</td>
            <td style="text-align: right;">{{ number_format($invoice->discount, 2) }}</td>
        </tr>
        <tr class="bold">
            <td colspan="3" class="label" style="text-align: right;">GRAND TOTAL</td>
            <td style="text-align: right;">{{ number_format($invoice->total - $invoice->discount, 2) }}</td>
        </tr>
        <tr>
            <td colspan="3" class="label" style="text-align: right;">PAID AMOUNT</td>
            <td style="text-align: right;">{{ number_format($invoice->paid, 2) }}</td>
        </tr>
        <tr>
            <td colspan="3" class="label" style="text-align: right;">DUE</td>
            <td style="text-align: right;">
                {{ number_format($invoice->total - ($invoice->discount + $invoice->paid), 2) }}</td>
        </tr>
    </table>

    <div class="signature">
        <div class="signature-line"></div>
        Authorized Signature
    </div>

    <div class="thank-you">
        THANK<br>YOU
    </div>

</body>

</html>
