<?php

namespace App\Http\Controllers;

use App\Models\BandService;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class BandServiceController extends Controller
{

    public function index()
    {
        $data = [
            'list' => BandService::all()
        ];
        return view('bandService.index', $data);
    }

    public function create()
    {
        return view('bandService.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:band_services,name',
        ]);
        $service = new BandService();
        $service->fill($request->all());
        $service->save();

        Toastr::success('Information inserted Successfully!.', '', ["closeButton" => "true", "progressBar" => "true"]);
        return redirect()->back();
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $data = [
            'service' => BandService::find($id)
        ];

        return view('bandService.edit', $data);
    }

    public function update(Request $request)
    {
        $service = BandService::find($request->id);
        $this->validate($request, [
            'name' => 'unique:band_services,name,' . $service->id,
        ]);
        $service->fill($request->all());
        $service->update();

        Toastr::success('Information updated Successfully!.', '', ["closeButton" => "true", "progressBar" => "true"]);
        return redirect()->route('band-service.index');
    }

    public function destroy($id)
    {
        $service = BandService::find($id);
        $service->delete();

        Toastr::error('Information deleted Successfully!.', '', ["closeButton" => "true", "progressBar" => "true"]);
        return redirect()->back();
    }
}
