<?php

namespace App\Jobs;

use App\Models\Client;
use App\Classes\MikrotikService\SyncWithMk;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\DB;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use App\Http\Controllers\Clients\IdDisconnectController;

class ClientSyncJobForSingle implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $client_id;
    public function __construct($client_id)
    {
        $this->client_id = $client_id;
    }

    public function handle()
    {
        if (checkAPI()) {
            $sync = new SyncWithMk();
            $sync->syncSingleClient($this->client_id);
        } else {

            $user = Client::with('pop', 'pop.nas')
                ->whereRaw('DATE_ADD(expire_date,INTERVAL payment_dadeline DAY) >= CURDATE()')
                ->where('id', $this->client_id)
                ->select('userid', 'password', 'clients_status', 'pop_id', 'package_id')
                ->first();

            if (!$user) {

                $user = Client::with('pop', 'pop.nas')
                    ->where('id', $this->client_id)
                    ->select('userid', 'password', 'clients_status', 'pop_id', 'package_id')
                    ->first();

                $user->clients_status = 'expired';
                $user->save();

                DB::table('radcheck')
                    ->updateOrInsert(
                        [
                            'username' => $user->userid,
                            'attribute' => 'Cleartext-Password'
                        ],
                        [
                            'op' => globalPermission('RadiusExpiration') ? ':=' : '!=',
                            'value' => $user->password
                        ]
                    );

                DB::table('radcheck')
                    ->updateOrInsert(
                        [
                            'username' => $user->userid,
                            'attribute' => 'NAS-IP-Address'
                        ],
                        [
                            'op' => ':=',
                            'value' => $user->pop->nas->nasname
                        ]
                    );

                DB::table('radusergroup')
                    ->updateOrInsert(
                        [
                            'username' => $user->userid,
                            'groupname' => $user->packages->id
                        ],
                        [
                            'priority' => 1
                        ]
                    );
                IdDisconnectController::disconnect($user);
            } else {

                $user->clients_status = 'active';
                $user->save();

                DB::table('radcheck')
                    ->updateOrInsert(
                        [
                            'username' => $user->userid,
                            'attribute' => 'Cleartext-Password'
                        ],
                        [
                            'op' => ':=',
                            'value' => $user->password
                        ]
                    );

                DB::table('radcheck')
                    ->updateOrInsert(
                        [
                            'username' => $user->userid,
                            'attribute' => 'NAS-IP-Address'
                        ],
                        [
                            'op' => ':=',
                            'value' => $user->pop->nas->nasname
                        ]
                    );

                DB::table('radusergroup')
                    ->updateOrInsert(
                        [
                            'username' => $user->userid,
                            'groupname' => $user->packages->id
                        ],
                        [
                            'priority' => 1
                        ]
                    );
            }
        }
    }
}
